"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendMessage = exports.getStatus = exports.initWhatsapp = void 0;
const baileys_1 = __importStar(require("@whiskeysockets/baileys"));
const qr_image_1 = __importDefault(require("qr-image"));
const session = new Map();
const VAR = "VAR_SESSION";
let connectionStatus = "Sedang cek koneksi";
let qrCode;
const initWhatsapp = () => __awaiter(void 0, void 0, void 0, function* () {
    yield connectToWhatsApp();
});
exports.initWhatsapp = initWhatsapp;
const getStatus = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    if (qrCode == null || qrCode == undefined) {
        res.json({
            success: true,
            data: connectionStatus,
            message: "Sukses menampilkan status",
        });
    }
    else {
        const code = qr_image_1.default.image(qrCode, { type: "png" });
        res.setHeader("Content-type", "image/png");
        code.pipe(res);
    }
});
exports.getStatus = getStatus;
const sendMessage = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    const { nama, whatsapp } = req.body;
    const wa = whatsapp[0];
    const waReplaced = whatsapp.replace(wa, "62");
    const msgClient = `Halo Bapak/Ibu ${nama}\n\nTerima kasih sudah mengisi formulir yang telah disediakan\n\nSelanjutnya jika Anda ingin melakukan pelaporan Nomor Objek Pajak (NOP) dapat mengakses dan mengisi formulir melalui link di bawah ini:\n\nhttps://forms.gle/U6XkP2JsEzqyX5mH8`;
    yield session
        .get(VAR)
        .sendMessage(`${waReplaced}@s.whatsapp.net`, { text: msgClient });
    res.json({
        success: true,
        data: `Halo ${nama} dengan nomor ${waReplaced}`,
        message: "Sukses",
    });
});
exports.sendMessage = sendMessage;
function connectToWhatsApp() {
    return __awaiter(this, void 0, void 0, function* () {
        const { state, saveCreds } = yield (0, baileys_1.useMultiFileAuthState)("auth");
        const sock = (0, baileys_1.default)({
            // can provide additional config here
            printQRInTerminal: true,
            auth: state,
        });
        sock.ev.on("creds.update", saveCreds);
        sock.ev.on("connection.update", (update) => {
            var _a, _b;
            const { connection, lastDisconnect } = update;
            if (update.qr) {
                qrCode = update.qr;
            }
            if (connection === "close") {
                const shouldReconnect = ((_b = (_a = lastDisconnect === null || lastDisconnect === void 0 ? void 0 : lastDisconnect.error) === null || _a === void 0 ? void 0 : _a.output) === null || _b === void 0 ? void 0 : _b.statusCode) !==
                    baileys_1.DisconnectReason.loggedOut;
                console.log("connection closed due to ", lastDisconnect === null || lastDisconnect === void 0 ? void 0 : lastDisconnect.error, ", reconnecting ", shouldReconnect);
                // reconnect if not logged out
                connectionStatus = "closed";
                if (shouldReconnect) {
                    connectToWhatsApp();
                }
            }
            else if (connection === "open") {
                connectionStatus = "connected";
                console.log("opened connection");
            }
        });
        sock.ev.on("messages.upsert", (m) => __awaiter(this, void 0, void 0, function* () {
            var _a, _b, _c, _d;
            const msg = m.messages[0];
            const noHp = msg.key.remoteJid;
            const nama = msg.pushName;
            if (!msg.key.fromMe && m.type === "notify") {
                if (noHp.includes("@s.whatsapp.net")) {
                    yield sock.sendMessage(noHp, {
                        text: `Halo Bapak/Ibu ${nama}, perkenalkan Saya Bot Pintar, asisten pribadi Bapenda Kab. Bojonegoro untuk Warga Agen Pajak (WAP) 2025\n\nUntuk Tahun 2025 diharap mendaftarkan diri Anda sebagai WAP terlebih dahulu, silahkan mengakses dan mengisi formulir melalui link di bawah ini:\n\nhttps://forms.gle/g9RPY2YdYbnveLNR7\n\nJika Anda sudah pernah mendaftarkan diri menjadi WAP, Anda dapat melakukan pelaporan Nomor Objek Pajak (NOP) dengan mengakses dan mengisi formulir melalui link di bawah ini:\n\nhttps://forms.gle/U6XkP2JsEzqyX5mH8\n\nUntuk Kanal Layanan Administrasi dapat melalui CHAT Whatsapp (tanpa panggilan telepon dan video) yang akan melayani Bapak/Ibu pada hari kerja mulai jam 08.00 s.d. 15.00 waktu setempat, dengan menghubungi nomor di bawah ini:\n\nhttps://bit.ly/3LSH5o3\n\nTerima kasih telah menghubungi Bot Pintar Bapenda Kab. Bojonegoro`,
                    });
                }
            }
        }));
        session.set(VAR, sock);
    });
}
